<!-- resources/views/jobsheet/create.blade.php -->
@extends('layouts.app')

@section('main')

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Job Sheets Report</title>
</head>
<body>
    <h1>Job Sheets Report</h1>
    <table border="1">
        <thead>
            <tr>
                <th>Customer Name</th>
                <th>Customer Number</th>
                <th>Device Brand</th>
                <th>Device Model</th>
                <th>Problem</th>
                <th>Status</th>
                <th>Phone Picture</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($jobSheets as $jobSheet)
                <tr>
                    <td>{{ $jobSheet->customer_name }}</td>
                    <td>{{ $jobSheet->customer_number }}</td>
                    <td>{{ $jobSheet->device_brand }}</td>
                    <td>{{ $jobSheet->device_model }}</td>
                    <td>{{ $jobSheet->problem }}</td>
                    <td>{{ $jobSheet->status }}</td>
                    <td>
                        @if ($jobSheet->phone_picture)
                            <img src="{{ asset('storage/' . $jobSheet->phone_picture) }}" alt="Phone Picture" width="100">
                        @else
                            No Image
                        @endif
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>

    <div>
        <p>Customer Name: {{ $jobSheet->customer_name }}</p>
        <p>Device Model: {{ $jobSheet->device_model }}</p>
        <p>Status: {{ $jobSheet->status }}</p>
        <!-- Link to the invoice page -->
        <a href="{{ route('jobsheet.invoice', $jobSheet->id) }}" target="_blank">Print Invoice</a>
    </div>

